
;;;Bosse-engineering                                                                                       
;;;Dipl.-Ing. Jrn Bosse                                                                                   
;;;Am Klei 5                                                                                               
;;;38458 Velpke                                                                                            
;;;Tel. 05364 / 989 677                                                                                    
;;;mobil. 0176 / 282 323 51                                                                                
;;;bosse@bosse-engineering.com                                                                             
;;;                                                                                                        
;;;--------------------------------------------------------------------------------------------------------
;;;Funktion c: OTB - Es werden auszuwhlenden Blcke in Blockdefinitionen kopiert.			   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;;;globale Variablen:										   	   
;;;- JB_OTB$DCL$_[x]_po (Positionen der Dialogfenster)							   
;;;- JB_OTB_$DCL$_File (temporre DCL-Datei)								   
;;;                                                                              Jrn Bosse, 04.01.23	   
;;;--------------------------------------------------------------------------------------------------------



;;;aufrufenden Funktionen
(defun c:OTB ( / )
  (JB_OTB)
  )

;;;Intro
(defun JB_OTB:Intro (str / )
  (princ "\nerstellt durch Bosse-engineering - www.bosse-engineering.com\n")
  (princ "\n----------------------OTB(1.0), 04.01.23---------------------")
  (princ str)
  (princ "\n-------------------------------------------------------------")
  )


;;;Liste mit Kategorien, Werte knnen an dieser Stelle ergnzt bzw. gendert werden

;;;Variablenliste
(defun JB_OTB:v_liste ( / )
  
  '(
     ( "DboxSettings" . (
                         ( "Dbox1" .
                            (
                             ( "JB_1_l1" . nil);;;BlocknameListe
			     ( "JB_1_r1-2" . 0);;;Radio: 0 = Filter, 1 = aus CAD
                             ( "JB_1_t1" . "*");;;Filterwert
                             ( "JB_1_to1" . "1");;;manuellen Basispunkt picken
                             ))))))
;;;Pfad fr SIC-Datei
(defun JB_OTB:pfad_ini ( / )
  (strcat (JBf_String:Userpfad
                           "c:\\acad\\" ;;;Hier ndern, wenn anderer Pfad gewnscht
                           )"OTB_sic.lsp")
  )

;;;Hauptfunktion
(defun JB_OTB ( / PFAD_INI V_LISTE OSMODE_ALT)
  (vl-load-com)

  (setq pfad_ini (JB_OTB:pfad_ini))

    (if (not(setq v_liste (if (findfile pfad_ini)
                          (load pfad_ini)nil)))
    (JBf_SIC:sichern
      (setq v_liste (JB_OTB:v_liste))pfad_ini nil))
  
  (vla-startundomark (vla-get-activedocument(vlax-get-acad-object)))
  (JBf_init
    '(("CMDECHO" 0)
      ("DIMZIN" 3)
      ))
  
  
  (JB_OTB:Intro "\nOTB: Objekte in Blockdefinitionen kopieren.")

  
  ;;;ab AutoCAD 2014, setzen von vertrauenswrdigen Pfaden fr Sicherungsdateien
  (if (JBf_AcadSystem:TrustedPaths?)
    (JBf_AcadSystem:TrustedPaths:Add (strcat(car(fnsplitl pfad_ini))"...")))

  (if (not
            (or (and JB_OTB_$DCL$_File(findfile JB_OTB_$DCL$_File))
                (setq JB_OTB_$DCL$_File (JB_OTB:dcl:Write))))
        (progn
          (alert "Die DCL-Datei konnte nicht geschrieben werden.")
          (exit)))

  (JB_OTB:Dbox1 v_liste pfad_ini)
   
  (princ "\nEnde.")
  (setq Osmode_Alt (getvar "OSMODE"))
  (JBf_Reinit)
  (setvar "OSMODE" Osmode_Alt)
  (vla-endundomark (vla-get-activedocument(vlax-get-acad-object))) 
  (princ)
  )

 

(defun  JB_OTB:v_liste:DboxSettings:get (key v_liste / )
  (cdr(assoc key(cdr (assoc "DboxSettings" v_liste))))
)


(defun JB_OTB:v_liste:DboxSettings:put (key liste v_liste / DboxList) 
  (setq DboxList (cdr (assoc "DboxSettings" v_liste)))
  (setq DBoxList (JBf_list:subst:gc DBoxList liste key))
  (setq v_liste (JBf_list:subst:gc v_liste DBoxList "DboxSettings"))
  v_liste
  )

;;;Blockdefionitionen - NameList
(defun JB_OTB:Dbox1:l1 ( / RETLIST)
  (vlax-for ITEM(vla-get-blocks(vla-get-activedocument (vlax-get-acad-object)))
    (if (and(=(vla-get-IsXref ITEM):vlax-false)
            (=(vla-get-IsLayout ITEM):vlax-false)
            (not(vl-string-search "*"(vla-get-name ITEM))))
      
      (setq RetList (cons (vla-get-name ITEM)RetList))
      )
    )
  (setq l1&Dbox1(vl-sort RetList '(lambda(e1 e2)(< e1 e2))))
  )

;;;Blockdefinitionen - NameList reduziert
(defun JB_OTB:Dbox1:BlockNameList:l1WorX ( / X)
  (setq l1WorX&Dbox1
         (vl-remove-if 'not
           (mapcar '(lambda(X)
                      (if (= (cdr(assoc "JB_1_r1-2" Settings&Dbox1))0)
                        (if (wcmatch (strcase X)(strcase (cdr(assoc "JB_1_t1" Settings&Dbox1))))
                          X)
                        X)
                      )
             l1&Dbox1)
           )
        )
  )

;;;Auswahl in Liste
(defun JB_OTB:Dbox1:BlockNameList:l1Sel ( / N X)
  (setq l1_sel&Dbox1 nil)
  (setq n -1)
  (if (cdr(assoc "JB_1_l1" Settings&Dbox1))
    (mapcar '(lambda(X)
               (setq n (+ n 1))
               (if (member (strcase X)(cdr(assoc "JB_1_l1" Settings&Dbox1)))
                 (setq l1_sel&Dbox1 (cons n l1_sel&Dbox1))
                 )
               )
      l1WorX&Dbox1)
    )
  (setq l1_sel&Dbox1 (vl-sort l1_sel&Dbox1 '(lambda(e1 e2)(< e1 e2))))
  (if (not l1_sel&Dbox1)
    (if l1WorX&Dbox1
      (setq l1_sel&Dbox1 '(0)))
    )
  )
      
    
  
  
  
;;;DBox 1
(defun JB_OTB:Dbox1 (v_liste pfad_ini / DCLID OK PinList&DBox1 l1&Dbox1 l1WorX&Dbox1 l1_sel&Dbox1)
  (setq Settings&Dbox1 (JB_OTB:v_liste:DboxSettings:get "Dbox1" v_liste))
  (JB_OTB:Dbox1:l1)
  (JB_OTB:Dbox1:BlockNameList:l1WorX)
  (JB_OTB:Dbox1:BlockNameList:l1Sel)
  
    
  (while (not (member ok '(1 99 103)))

    (setq DclId (JBf_Dcl:Load_dialog JB_OTB_$DCL$_File "JB_OTB_1" JB_OTB$DCL$_1_po))

    (JB_OTB:Dbox1:set)
    (JB_OTB:Dbox1:mode)
    
    
    (mapcar '(lambda (A) (action_tile A (strcat "(JB_OTB:Dbox1:action \"" A "\")")))
            '("JB_1_b1"  "JB_1_b2" "JB_1_b3"
              "JB_1_l1"
              "JB_1_r1" "JB_1_r2"
              "JB_1_to1"
	      "accept" "cancel"
             )
    )
    (setq ok (start_dialog))
    (unload_dialog DclId)
    
    (cond ((= ok 99) ;;;Ende
           (setq v_liste (JB_OTB:v_liste:DboxSettings:put "Dbox1" Settings&dbox1 v_liste))
           (JBf_SIC:sichern v_liste pfad_ini nil)
           )
          ((= ok 102);;;Blockreferenzen aus CAD
           (JB_OTB:Dbox1:action:b2)
           )
          ((= ok 103);;;OBT-Objekte entfernen
           (JB_OTB:Dbox1:action:b3)
           (setq v_liste (JB_OTB:v_liste:DboxSettings:put "Dbox1" Settings&dbox1 v_liste))
           (JBf_SIC:sichern v_liste pfad_ini nil)
           )
          ((= ok 1);;;Objekte auswhlen und in Blockdefinitionen kopieren
           (JB_OTB:Dbox1:CopyToBlock)
           (setq v_liste (JB_OTB:v_liste:DboxSettings:put "Dbox1" Settings&dbox1 v_liste))
           (JBf_SIC:sichern v_liste pfad_ini nil)
           )
          )
    ) 
  )


;;;Action: Blockreferenzen aus CAD auswhlen
(defun JB_OTB:Dbox1:action:b2 ( / AWS N NAME RETLIST)
  (if (and(princ "\nWhlen Sie Blockreferenzen:")
          (setq aws (ssget (list (cons 0 "INSERT")))))
    (progn
      (setq n 0)
      (repeat (sslength aws)
        (setq name(vla-get-Effectivename(vlax-ename->vla-object (ssname aws n))))
        (if (not(member name RetList))
          (setq RetList (cons name RetList)))
        (setq n (+ n 1))
        )
      (setq RetList (vl-sort RetList '(lambda(e1 e2)(< e1 e2))))
      (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 "*" "JB_1_t1"))
      (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 (mapcar 'strcase RetList)"JB_1_l1"))
      (JB_OTB:Dbox1:BlockNameList:l1WorX)
      (JB_OTB:Dbox1:BlockNameList:l1Sel)
      )
    )
  )


;;;Objekte wieder aus  Blockreferenzen entfernen
(defun JB_OTB:Dbox1:action:b3 ( / ITEM LOGLIST X)
  (mapcar '(lambda(X)
             (vlax-for ITEM (vla-item(vla-get-blocks
                                       (vla-get-activedocument(vlax-get-acad-object)))
                              (nth X l1WorX&Dbox1))
               (if (=(JBf_list_xdaten_read:Vla "JB_OBT" ITEM 1000)"OBT")
                 (progn
                   (vla-delete ITEM)
                   (setq LogList (cons (nth X l1WorX&Dbox1)LogList))
                   )
                 )
               )
             )
    l1_sel&Dbox1)
  (if LogList
    (progn
      (vla-regen (vla-get-activedocument(vlax-get-acad-object)) acActiveViewport)
      (alert (strcat "Die \"OBT\"-Objekte wurden in folgenden Blockdefinitionen entfernt:\n"
               (apply 'strcat
                      (mapcar '(lambda(X)
                                 (strcat "\n- " X))
                        (reverse LogList)))))
      )
    )
  )
  
      
      


;;;Action b1: Filterwert
(defun JB_OTB:Dbox1:action:b1 ( / WERT)
  (if (setq wert (JB_OTB:Dbox2))
    (progn
      (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 wert "JB_1_t1"))
      (JB_OTB:Dbox1:BlockNameList:l1WorX)
      (setq Settings&dbox1(JBf_list:subst:gc Settings&dbox1(mapcar 'strcase l1WorX&Dbox1)"JB_1_l1"))
      (JB_OTB:Dbox1:BlockNameList:l1Sel)      
      (JB_OTB:Dbox1:set)
      (JB_OTB:Dbox1:mode)
      )
    )
  )

;;;Auswahl in Liste => der aktuelle Filter oder die Auswahl ber Blockreferenzen bleibt erhalten
(defun JB_OTB:Dbox1:action:l1 ( / )
  (setq l1_sel&Dbox1 (mapcar 'atoi(JBf_String:Delimiter->List $value " ")))
  (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 (mapcar '(lambda(X)(strcase(nth X l1WorX&Dbox1)))l1_sel&Dbox1)"JB_1_l1"))
  )
          
;;;Action (Variable global in Aufrufender Funktion)
(defun JB_OTB:Dbox1:action (key / NAME X)

  (cond
    ((= key "JB_1_r1")
     (setq Settings&Dbox1 (JBf_list:subst:gc Settings&Dbox1 (- 1 (atoi $value))"JB_1_r1-2"))
     (JB_OTB:Dbox1:BlockNameList:l1WorX)
     (JB_OTB:Dbox1:BlockNameList:l1Sel)
     (JB_OTB:Dbox1:set)
     (JB_OTB:Dbox1:mode)
     )
    ((= key "JB_1_r2")
     (setq Settings&Dbox1 (JBf_list:subst:gc Settings&Dbox1 (atoi $value)"JB_1_r1-2"))
     (JB_OTB:Dbox1:BlockNameList:l1WorX)
     (JB_OTB:Dbox1:BlockNameList:l1Sel)
     (JB_OTB:Dbox1:set)
     (JB_OTB:Dbox1:mode)
     )
    ((= key "JB_1_to1")
     (setq Settings&Dbox1 (JBf_list:subst:gc Settings&Dbox1 $value "JB_1_to1"))
     )
    ((= key "JB_1_l1");;;Listenauswahl
     (JB_OTB:Dbox1:action:l1)
     )
    ((= key "JB_1_b1")    ;;;Filterwert
     (JB_OTB:Dbox1:action:b1)
     )
    ((= key "JB_1_b2")    ;;;Blockreferenzen aus CAD
     (setq JB_OTB$DCL$_1_po (done_dialog 102))
     )

    ((= key "JB_1_b3")    ;;;Objekte entfernen
     (setq JB_OTB$DCL$_1_po (done_dialog 103))
     )

    ((= key "accept") ;;;Objekte auswhlen
     (setq JB_OTB$DCL$_1_po (done_dialog 1))
     )

    ((= key "cancel") ;;;Ende     
     (setq JB_OTB$DCL$_1_po (done_dialog 99))
     )
    )
)


    
;;;DBox1: setten
(defun JB_OTB:Dbox1:set ( / X)
  
  (start_list "JB_1_l1" 3)
  (mapcar 'add_list l1WorX&Dbox1)
  (end_list)
  (if l1_sel&Dbox1
    (progn
      (set_tile "JB_1_l1" "")
      (set_tile "JB_1_l1" (vl-string-right-trim " "(apply 'strcat(mapcar '(lambda(X)(strcat (itoa X) " "))l1_sel&Dbox1))))
      )
    (set_tile "JB_1_l1" "")
    )
  (mapcar '(lambda(X)
             (set_tile (strcat "JB_1_"(car X))(cadr X)))
    (list
      (list "t1" (cdr(assoc "JB_1_t1" Settings&dbox1)))
      (list "r1" (itoa(- 1 (cdr(assoc "JB_1_r1-2" Settings&dbox1)))))
      (list "r2" (itoa(cdr(assoc "JB_1_r1-2" Settings&dbox1))))
      (list "to1" (cdr(assoc "JB_1_to1" Settings&dbox1)))
           
      )
    )
  )
;;;DBox1, moden
(defun JB_OTB:Dbox1:mode ( / )
  (if (not l1WorX&Dbox1)
    (progn
      (mode_tile "JB_1_l1" 1)
      (mode_tile "accept" 1)
      (alert "Es ist noch keine Blockdefinion ausgewhlt."))
    (progn
      (mode_tile "JB_1_l1" 0)
      (mode_tile "accept" 0)
      )
    )

  (if (=(cdr(assoc "JB_1_r1-2" Settings&dbox1))0)
    (progn
      (mode_tile "JB_1_t1" 0)
      (mode_tile "JB_1_b1" 0)
      (mode_tile "JB_1_b2" 1))
    (progn
      (mode_tile "JB_1_t1" 1)
      (mode_tile "JB_1_b1" 1)
      (mode_tile "JB_1_b2" 0))
    )
  )
;;;Kopie von Objekte erstellen
(defun JB_OTB:Dbox1:CopyToBlock:vla-objList (aws / N RETLIST)
  (setq n 0)
  (repeat (sslength aws)
    (setq RetList (cons(vla-copy(vlax-ename->vla-object(ssname aws n)))RetList))
    (setq n (+ n 1)))
  ;;;XDaten als Kennung anhngen, damit diese wieder gelscht werden knnen
  (mapcar '(lambda(X)
             (JBf_list_xdaten_append:Vla "JB_OBT" X '((1000 . "OBT"))))
    RetList)
  (reverse RetList)
  )

;;;vla-obj transformieren in Welt
(defun JB_OTB:Dbox1:CopyToBlock:transToWelt (vla-obj / )
  (vla-TransformBy vla-obj (vlax-tmatrix (JB_OTB:TransMatrix:VonNach 1 0)))
  )
  
;;;Transformationsmatrix 4x4
(defun JB_OTB:TransMatrix:VonNach (von nach / X Y)
  (append
    (mapcar
      '(lambda(X Y)
         (append (trans X von nach 'T) (list Y))
         )
      (list '(1.0 0.0 0.0) '(0.0 1.0 0.0) '(0.0 0.0 1.0))
      (trans '(0.0 0.0 0.0) nach von)
      )
    (list '(0.0 0.0 0.0 1.0))
    )
  )


;;;Basispunkt, Objekte schieben
(defun JB_OTB:Dbox1:CopyToBlock:Move (p vla-objList / )
  (mapcar '(lambda(X)
             (vla-move X (vlax-3D-Point p)(vlax-3D-Point (trans'(0 0 0)1 0))))
    vla-objList)
  )

;;;Kopieren in Blockdefinitionen
(defun JB_OTB:Dbox1:CopyToBlock ( / AWS P VLA-OBJLIST X LOGLIST)
  (if (and (princ "\nWhlen Sie Objekte:")
           (setq aws (ssget))
           (setq vla-objList (JB_OTB:Dbox1:CopyToBlock:vla-objList aws))
           (or (=(cdr(assoc "JB_1_to1" Settings&dbox1))"0")
               (and (setq p (getpoint "\nPicken Sie den Basispunkt:"))
                    (setq p (trans p 1 0))
                    (JB_OTB:Dbox1:CopyToBlock:Move p vla-objList))))
                    
    
    (progn
      
      ;;;wenn BKS, dann in Welt kopieren
      (mapcar 'JB_OTB:Dbox1:CopyToBlock:transToWelt vla-objList)
      (mapcar '(lambda(X)
                 (vla-copyObjects
                   (vla-get-activeDocument (vlax-get-acad-object))
                   (JBf_vla-copyObjects:Safearray vla-objList)
                   (vla-item(vla-get-blocks
                              (vla-get-activedocument(vlax-get-acad-object)))
                     (nth X l1WorX&Dbox1))
                   )
                 (setq LogList (cons (nth X l1WorX&Dbox1)LogList))
                 )
        l1_sel&Dbox1)
      (mapcar 'vla-delete vla-objList)
      (vla-regen (vla-get-activedocument(vlax-get-acad-object)) acActiveViewport)
      (alert (strcat "Die Objekte wurden in folgenden Blockdefinitionen kopiert:\n"
               (apply 'strcat
                      (mapcar '(lambda(X)
                                 (strcat "\n- " X))
                        (reverse LogList)))))
      )
    )
  )
      
  
   
;;;DBox2 => Filterwert
(defun JB_OTB:Dbox2 ( / DCLID OK wert&Dbox2)
  (setq wert&Dbox2 (cdr(assoc "JB_1_t1" Settings&dbox1)))
   
  (while (not (member ok '(1 99)))

    (setq DclId (JBf_Dcl:Load_dialog JB_OTB_$DCL$_File "JB_OTB_2" JB_OTB$DCL$_2_po))

    (set_tile "JB_2_e1" wert&Dbox2)
    (mode_tile "JB_2_e1" 2)
    
    (mapcar '(lambda (A) (action_tile A (strcat "(JB_OTB:Dbox2:action \"" A "\")")))
            '(
	      "accept"
	      "cancel"
	      
             )
    )

    (setq ok (start_dialog))
    (unload_dialog DclId)

    (if(and(= ok 1)(= wert&Dbox2 ""))
      (setq wert&Dbox2 "*")            
      )    
    )
  (if (= ok 1)
    wert&Dbox2)
  )

;;;Action (Variable global in Aufrufender Funktion)
(defun JB_OTB:Dbox2:action (key / )
  (cond
    ((= key "accept")    ;;;OK
     (setq wert&Dbox2 (vl-string-subst "." ","(get_tile "JB_2_e1")))
     (setq JB_OTB$DCL$_2_po (done_dialog 1)))
    ((= key "cancel")    ;;;Ende
     (setq JB_OTB$DCL$_2_po (done_dialog 99))) 
  )
)
;;;DCL-schreiben
(defun JB_OTB:dcl:Write ( / file)  
  (if (and (setq JB_OTB_$DCL$_File (vl-filename-mktemp (strcat "OTB.dcl")))
           (setq file (open JB_OTB_$DCL$_File "w"))
      )
    (progn
      (mapcar '(lambda (A)
                       (write-line A file)
               )
              (mapcar '(lambda (A)
                               (strcat "\n" A)
                       )
              (list
                "JB_OTB_1: dialog {label = \"Objekte in Blockdefinitionen kopieren\";"
                ":boxed_column {label = \"Blockdefinitionen\";"
                ":list_box {key = \"JB_1_l1\"; label = \"bitte auswhlen\";multiple_select = true;}"
                ":row{"
                ":radio_column{"
                ":radio_button {key = \"JB_1_r1\"; label = \"Filter\";}"
                ":radio_button {key = \"JB_1_r2\"; label = \"von Blockreferenzen\";}}"
                ":column{"
                ":text {key = \"JB_1_t1\"; label = \"MeinFilter\"; width = 10;}"
                "}"
                ":column {"
                ":button {key = \"JB_1_b1\"; label = \"&Filterwert...\";}"
                ":button {key = \"JB_1_b2\"; label = \"aus &CAD<\";}"
                "}"
                "}"
                "}"
                ":boxed_column {label = \"Optionen\";"
                ":toggle {key = \"JB_1_to1\"; label = \"manueller Basispunkt\";}"
                "}"
                ":row{fixed_width = true;alignment = centered;"
                ":retirement_button {label = \"Objekte &auswhlen\"; key= \"accept\";is_default = true; fixed_width=true;}"
                ":spacer {width = 2;}"
                ":button {key = \"JB_1_b3\"; label = \"Objekte entfernen\";fixed_width=true;}"
                ":spacer {width = 2;}"
                ":retirement_button {label = \"&Ende\"; key= \"cancel\";is_cancel = true; fixed_width=true;}"
                "}}"
                "JB_OTB_2: dialog {label = \"Filterwert\";"
                ":boxed_column {label = \"bitte eingeben\";"
                ":edit_box {key = \"JB_2_e1\"; allow_accept = true;}"
                "}"
                "ok_cancel;}"


               )
              )
      )
      (close file)
      JB_OTB_$DCL$_File
    )
  )
)


;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine verwaltungstechnische Funktionen							   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Fehlermeldung
;;;Fehlermeldung;;;
(defun JBf_Error  (s)
  (print (strcat "***Fehler*** " s))
  (JBf_Reinit))

;;;Initialisierungsfunktion
(defun JBf_init (InitVaris / )
  (setq	JB_Error *error*
        *error* JBf_Error)
  (vl-load-com)
  ;;;Systemvariablen aktuelle Einstellungen fr ReInit speichern
  (setq JBf$ReInit$Varis
         (mapcar '(lambda(A)
                    (list (car A)(getvar (car A))))InitVaris))
  ;;;Vorgabeeistellungen fr Systemvariablen
  (mapcar '(lambda(A)
             (if (cadr A)
               (setvar (car A)(cadr A))))InitVaris)
  )

;;;Reinitialisierung
(defun JBf_Reinit ( / n)
  ;;;Systemvariablen ReInitialisieren
  (mapcar '(lambda(A)
             (setvar (car A)(cadr A)))JBf$ReInit$Varis)
  (setq JBf$ReInit$Varis nil)
  (princ)
)

;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Strings								   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;benutzerspezifischer Pfad zum Speichern von Programmeinstellungen
(defun JBf_String:Userpfad (UserPfad / )
  (setq UserList (JBf_String:Delimiter->List UserPfad "\\")
        Pfad (strcat (car UserList)"\\"))

  ;;;wenn UserPfad noch nicht vorhanden, dann erstellen
  (mapcar '(lambda(A)
             (setq Pfad (strcat Pfad A "\\"))
             (if (not (JBf_String:FilePath? Pfad))
               (vl-mkdir Pfad)))
    (cdr UserList))
  userpfad
  )
;;;String anhand Trennzeichen in Liste zurckgeben
(defun JBf_String:Delimiter->List (Str Delim / StrList)
  (setq Str (vl-string-left-trim Delim Str)
	Str (vl-string-right-trim Delim Str))
  (if (vl-string-search Delim Str)
    (progn
      (while (vl-string-search Delim Str)
        (setq StrList (cons (substr Str 1 (vl-string-search Delim Str))StrList)
	      Str (vl-string-left-trim Delim(substr Str(+(vl-string-search Delim Str)(+ (strlen Delim)1))))))
      (if (/= Str "")
        (setq StrList (cons Str StrList))))
    (setq StrList (cons Str StrList)))
  (reverse StrList))

;;;Es wird ein String anhand eines Trennzeichens zerlegt, wenn das trennzeichen doppelt vorkommt, dann wird ein Leerzeichen als Zwischenraum zurckgegeben
(defun JBf_string:Trennzeichen->listCharsWithBlanks (str str_trenn / A RETLIST SUB TABN)
  (setq str_trenn (car(vl-string->list str_trenn)))
  (mapcar '(lambda(A)
             (if (/= A str_trenn)
               (setq sub (cons A sub)
                     TabN nil)
               (progn
                 (setq TabN (if (not TabN) 1 (+ TabN 1)))
                 (if (= TabN 1)
                   (setq RetList (cons (reverse sub)RetList)
                         sub nil)
                   (setq RetList (cons nil RetList)))))
             )
    (vl-string->list str))
  (if Sub (setq RetList (cons (reverse Sub) RetList)))
  (mapcar '(lambda(A)
             (if A (vl-list->string A)""))(reverse RetList)))

;;;Dateipfad prfen
(defun JBf_String:FilePath? (Pfad / FSO TRUE-FALSE)
  (setq Pfad (if(vl-string-search "." Pfad)(car(fnsplitl  Pfad))Pfad))
  (if (setq FSO (vlax-create-object "Scripting.FilesystemObject"))
    (progn
      (if (vlax-method-applicable-p FSO 'FOLDEREXISTS)
        (setq TRUE-FALSE
               (=(vl-catch-all-apply
                   'vlax-invoke-method
                   (list FSO 'FOLDEREXISTS Pfad)):vlax-true))
        (vlax-release-object FSO))))
  TRUE-FALSE)
	  
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Listen								   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Es wird der GcN-Eintrag gesubst
(defun JBf_list:subst:gc (liste Wert GcN / )
  (subst (cons GcN Wert)(assoc GcN liste)liste))


;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Listen in SIC-Datei sichern  					   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Liste in LSP-Datei sichern
;;;Sichern von Einstellungen, Ausfhrung
;;;liste => DottetPairList, die es zu sichern gilt
;;;path => vollstndiger Dateipfad mit Dateiname
;;;AcadTrustCheck => 'T or NIL, es wird bei 'T ein temnporrer TrustedPath erstellt und danach auch gleich wieder gelscht
(defun JBf_SIC:sichern (liste FilePath AcadTrustCheck / FILESTREAM X)

  (setq FileStream (open FilePath "w"))
  (write-line "'(" FileStream)
  (mapcar '(lambda (X)
                   (JBf_SIC:sichern:prin1 X FileStream)
           )
          liste
  )
  (write-line ")" FileStream)
  (close FileStream)

  (if
    (if AcadTrustCheck
      (car (JBf_SIC:load:Catch FilePath nil))
      (vl-catch-all-error-p
        (vl-catch-all-apply 'JBf_SIC:load (list FilePath))
      )
    )


    (if (findfile (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
      (progn
        (alert (strcat "Die Sicherungsdatei \n\n"
                       FilePath
                       "\n\n ist fehlerhaft und wird automatisch durch die BAK-Datei\n\n"
                       (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                       "\n\nersetzt."
               )
        )
        (if (vl-file-delete FilePath)
          (vl-file-copy (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak") FilePath)
          (alert (strcat "Die Sicherungsdatei \n\n"
                         FilePath
                         "\n\n ist fehlerhaft und konnte nicht automatisch durch die BAK-Datei\n\n"
                         (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                         "\n\nersetzt werden. Bitte fhren Sie diesen Arbeitsgang manuell durch."
                 )
          )
        )
      )

      (alert (strcat "Die Sicherungsdatei \n\n"
                     FilePath
                     "\n\n ist fehlerhaft, bitte lschen Sie diese, anderfalls kann das Programm nicht mehr\n"
                     "ordnungsgem starten."
             )
      )
    )
    (if (findfile (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
      (if (vl-file-delete (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
        (vl-file-copy FilePath (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
        (alert (strcat "Fr die Sicherungsdatei \n\n"
                       FilePath
                       "\n\n konnte keine BAK-Datei erstellt werden. Bitte lschen Sie die vorh. BAK-Datei\n\n"
                       (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                       "\n\nmanuell."
               )
        )
      )
      (vl-file-copy FilePath (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
    )
  )
)
;;;Laden der Datei um zu prfen, ob diese korrekt ist!
  (defun JBf_SIC:load (FilePath /)
    (load FilePath)
  )
;;;Pfad muss existieren, Prfung in aufrufender Funktion und temporrem TrustPath
  (defun JBf_SIC:load:Catch (PathFile ErrMsg / ERROR RETVAL TRUTHPATHSET)
    (if (JBf_AcadSystem:TrustedPaths?)
      (progn
        (setq TruthPathSet 'T)
        (JBf_AcadSystem:TrustedPaths:Add (strcat (car (fnsplitl PathFile)) "..."))
      )
    )

    (setq error (vl-catch-all-error-p
                  (setq RetVal (vl-catch-all-apply 'JBf_SIC:load (list PathFile)))
                )
    )
    (if (and error ErrMsg)
      (alert ErrMsg)
    )

    (if TruthPathSet
      (JBf_AcadSystem:TrustedPaths:Delete (strcat (car (fnsplitl PathFile)) "..."))
    )


    (list error RetVal)
  )
;;;Iteratives lustiges Listenschreiben
  (defun JBf_SIC:sichern:prin1 (A FileStream / B)

    (cond  ;;;wenn einzelner Eintrag
                 ((atom A)
                        (write-line (vl-prin1-to-string A) FileStream)
                 )
      ((and (atom (car A)) (not (cdr A)))  ;;;GC ohne Wert
            (write-line (vl-prin1-to-string A) FileStream)
      )
      ((and (atom (car A)) (cdr A) (not (listp (cdr A))))  ;;;DottedPair
            (write-line (vl-prin1-to-string A) FileStream)
      )
      ((and (atom (car A)) (cdr A) (listp (cdr A)) (= (length (cdr A)) 1) (atom (car (cdr A))))  ;;;GC + Wert
            (write-line (strcat "(" (vl-prin1-to-string (car A))) FileStream)
            (mapcar '(lambda (B)
                             (JBf_SIC:sichern:prin1 B FileStream)
                     )
                    (cdr A)
            )
         (write-line ")" FileStream)
      )
      ((and (atom (car A)) (cdr A) (listp (cdr A)))  ;;;GC + Liste
            (write-line (strcat "(" (vl-prin1-to-string (car A))) FileStream)
            (mapcar '(lambda (B)
                             (JBf_SIC:sichern:prin1 B FileStream)
                     )
                    (cdr A)
            )
         (write-line ")" FileStream)
      )
      ( 'T
        (write-line "(" FileStream)
        (mapcar '(lambda (B)
                         (JBf_SIC:sichern:prin1 B FileStream)
                 )
                A
        )
         (write-line ")" FileStream)
      )
    )
  )             

;;;--------------------------------------------------------------------------------------------------------
;;;Setzen von "TrustedPaths's" sab ACAD  2014								   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Prfen, ob bereits TrustedPaths in der aktuelle Version verwendet werden knnen
(defun JBf_AcadSystem:TrustedPaths? ( / )
  (and (= "ACAD" (strcase (getvar "PROGRAM"))) (getvar "SECURELOAD"))
  )

;;;Pfadangaben immer mit BackSlashes, "\\..." hinten angestellt, damit alle untergeordneten Verzeichnisse bercksichtigt werden
(defun JBf_AcadSystem:TrustedPaths:Add (pfad / TRUSTEDPATHS)
  (setq TrustedPaths(if (getvar "TRUSTEDPATHS")(getvar "TRUSTEDPATHS")""))
  (if(not(member (strcase pfad)(mapcar 'strcase (JBfd_AcadSystem:TrustedPath:Split TrustedPaths))))
    (setvar "TRUSTEDPATHS"(strcat TrustedPaths ";" pfad)))
  )

;;;Pfad entfernen
(defun JBf_AcadSystem:TrustedPaths:Delete (pfad / A TRUSTEDPATHS)
  (setq TrustedPaths(if (getvar "TRUSTEDPATHS")(getvar "TRUSTEDPATHS")""))
  (setvar "TRUSTEDPATHS"
	  (vl-string-right-trim ";"(apply 'strcat(mapcar '(lambda(A)
							   (strcat A ";"))
							(vl-remove-if 'not (mapcar '(lambda(A)
										      (if(/= (strcase pfad)(strcase A))A))
										   (JBfd_AcadSystem:TrustedPath:Split TrustedPaths)))))))
  )

;;;String splitten an Semikolons, als Liste zurckgeben
(defun JBfd_AcadSystem:TrustedPath:Split (TrustedPaths / A RETLIST TEMP)
  (mapcar '(lambda(A)
	     (if (/= A 59)
	       (setq temp (cons A temp))
	       (setq RetList (cons (vl-list->string(reverse temp))RetList)
		     temp nil))
	     )
	     (vl-string->list TrustedPaths))
  (if temp
    (setq RetList (cons (vl-list->string (reverse temp))RetList)))
  (reverse RetList))
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Dcl									   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;DCL-Dialogfenster laden
(defun JBf_Dcl:Load_dialog (FileName DialogName JB_$DCL$_x_po / DclId)
  (setq DclId (load_dialog FileName))
  (if	JB_$DCL$_x_po
    (if (not (new_dialog DialogName DclId "" JB_$DCL$_x_po))
      (exit))
    (if (not (new_dialog DialogName DclId))
      (exit)))
  DclId
  )


;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => VLA									   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
(defun JBf_list_xdaten_read:Vla (art vla-obj gc_nr / DATACODE N RETLIST VALUE VARDATATYPES VARDATAVALUES VARVALUE)

  (vla-GetXData vla-obj art 'VarDataTypes 'VarDataValues)
  (if VarDataTypes
      (progn
        ;; Get the dimension of the safearray
        (setq n (vlax-safearray-get-l-bound VarDataTypes 1))
        
         (while (<= n (vlax-safearray-get-u-bound VarDataTypes 1))
           (setq dataCode (vlax-safearray-get-element VarDataTypes n))
           (setq VarValue (vlax-safearray-get-element VarDataValues n))
           
            ;; VarValue contains the variant, but we need the Lisp value of it

           (if (and (> dataCode 1009) (< dataCode 1040))
             ;; Test to see if it's a point Variant
             (setq Value (vlax-safearray->list (vlax-variant-value VarValue)))
             (setq Value (vlax-variant-value VarValue))
            )
            ;; Create the list
            (setq RetList (append RetList (list (cons dataCode Value))))
            (setq n (+ n 1))
         ) ;_ end of while
      ) ;_ end of progn
    )
  (setq RetList(vl-remove-if '(lambda(X)(=(car X)1001))RetList))
  (if gc_nr
    (cdr(assoc gc_nr RetList))
    RetList))

;;;XDaten mit VLA-Funktionen anhngen, weil z.B. in DBX-Objekten dann auch verllich Daten zurck gegeben werden
(defun JBf_list_xdaten_append:Vla (art vla-obj liste / ARRAYTYPES ARRAYVALUES CODES N VALUES)
  ;; Register an application name
  (regapp art)

  ;; Attach some xdatas:
  ;; 1001: application name  ;; 1000: string ;; 1010: 3D point ;; 1040: real ; 1070: 16bit integer
  (setq codes (cons 1001 (mapcar 'car liste))
        values (cons art (mapcar 'cdr liste)))

  ;; Create the Safe and Variant Arrays needed for vla-SetXData
  (setq ArrayTypes
         (vlax-make-safearray
           vlax-vbInteger
           (cons 0 (-(length codes)1))
           )
        ArrayValues
         (vlax-make-safearray
           vlax-vbVariant
           (cons 0 (-(length codes)1))
           ))
  ;;; Fill the Arrays; simple list works
  (vlax-safearray-fill ArrayTypes codes)

  ; A more complex list needs to be constructed one element at a time:
  (setq n 0)
  (while (< n (length codes))
    (if (=(type (nth n values)) 'LIST)
      (vlax-safearray-put-element
        ArrayValues
        n
        (vlax-3d-point (nth n values)))
      (vlax-safearray-put-element ArrayValues n (nth n values)))
    (setq n (+ n 1)))

  (vla-SetXData vla-obj ArrayTypes ArrayValues)
  )


;;;Safearray zur Bergabe der vla-objekte
(defun JBf_vla-copyObjects:Safearray (vla-objList / )
  (vlax-safearray-fill
    (vlax-make-safearray
      vlax-vbObject
      (cons 0 (-(length vla-objList)1)))
    vla-objList)
  )


;;;--------------------------------------------------------------------------------------------------------
;;;Info fr Textfenster nach dem laden des Programms							   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(princ (strcat
          "\n|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++|"
          "\n|Objekte in Blockdefinitionen kopieren.                      |"
          "\n|------------------------------------------------------------|"
          "\n|erstellt durch Bosse-engineering - www.bosse-engineering.com|"
          "\n|------------------------------------------------------------|"
          "\n|Befehlszeilenaufruf: OTB                                    |"
          "\n|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++|"
          )
       )
(princ)














    
      
         
  
  




  





                 

